<?php
/**
 * Created by G. Kipouros for Exis.com.gr
 * User: gkipouros
 * Date: 30/9/2018
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('memory_limit', '1024M');

if( php_sapi_name() !== 'cli' && $_SERVER['HTTP_HOST'] !='localhost' ) {
    die("Meant to be run from command line");
}


include (dirname(__FILE__)."/functions.php");
include (dirname(__FILE__)."/config.php");
define('BASE_PATH', exis_find_wordpress_base_path()."/" );
define('WP_USE_THEMES', false);
$startime=getmicrotime();

require(BASE_PATH . 'wp-load.php');

ini_set('display_errors', 1);
echo exis_show_run_time("WP files loaded");

if ( ! function_exists( 'wp' ) )
    die( 'Sorry, looks like WordPress isn\'t loaded.' );

$sql = "SELECT * FROM taxiplon_zones";
$results = $wpdb->get_results($sql);
foreach ($results as $zone) {
    $existing_zones[$zone->post_code] = $zone->zone;
}

$updated_counter = 0;
$h = fopen($csv['zones'], "r");
$current_data = array();
while (($row = fgetcsv($h, 1000, ";")) !== FALSE) {

    $current_data['post_code']   = trim($row[1]);
    $current_data['zone']        = trim($row[0]);

    if ($current_data['zone']<1 || $current_data['zone'] > 100) {
        continue;
    }

    // Check if location/zone/taxi_id already exists
    if ($existing_zones[$current_data['post_code']]) {

        // Update row
        $update_data = array (
                'zone'   => $current_data['zone'],
        );
        $where_data = array(
                'post_code'          => $current_data['post_code'],
        );
        $result = $wpdb->update('taxiplon_zones', $update_data, $where_data);
        $updated_counter++;
    } else {
        // Insert new row
        $insert_data = array (
                'post_code'          => $current_data['post_code'],
                'zone'              => $current_data['zone'],
        );

        $result = $wpdb->insert('taxiplon_zones', $insert_data);
        $inserted_ids[] = $wpdb->insert_id;
    }



}
echo "<h3>Inserted ".count($inserted_ids)." rows and Updated ".$updated_counter." rows!</h3>";

fclose($h);